/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair;

import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccess;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccessFactory;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.TextTableAnd3ButtonGroupDataBean;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.service.panel.PBFedSwitchRepair30;
import com.ibm.hwmca.p.service.panel.PBFedSwitchRepair40;
import com.ibm.hwmca.p.service.serviceaction.repair.PIEndOfCall;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.panel.PBCommonEnterRepairDescription;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterIsolateQuery20;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterRepairSupport;
import com.ibm.hwmca.xfw.service.serviceaction.DefaultServiceAction;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class FedSwitchRepair
extends DefaultServiceAction {
    private static final String TRACE_MASKT = "XRVPIFST";
    private static final String TRACE_MASKF = "XRVPIFSF";
    private static final String TRACE_MASKD = "XRVPIFSD";
    private String defaultProcedureId = "piphps";
    private String procedureId;

    public FedSwitchRepair() {
        Trace.trace(TRACE_MASKT, "<> FedSwitchRepair default ctor");
    }

    public FedSwitchRepair(PersistentData persistentData) throws ServiceActionException {
        super(persistentData);
        Trace.trace(TRACE_MASKT, "<> FedSwitchRepair persistent data ctor. persistentData: " + persistentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map userData) throws ServiceActionException {
        Trace.trace(TRACE_MASKT, "-> FedSwitchRepair.start");
        try {
            super.showStarted(userData);
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            CommonProblem cp = (CommonProblem)userData.get("SERVICEABLE_EVENT");
            List frus = cp.getParts();
            Trace.trace(TRACE_MASKF, "PIServiceActionFactory - repair, number of FRUs=" + frus.size());
            this.procedureId = this.defaultProcedureId;
            if (frus != null) {
                Iterator it = frus.iterator();
                while (it.hasNext()) {
                    CommonPaFru cpf = (CommonPaFru)it.next();
                    String partNum = cpf.getPartNumber();
                    if (partNum == null || !partNum.toUpperCase().startsWith("HPS")) continue;
                    this.procedureId = partNum;
                    break;
                }
            }
            try {
                String hmcIPAddress;
                HashMap<String, Object> displayMap = new HashMap<String, Object>();
                Locale clientLocale = Locale.US;
                try {
                    hmcIPAddress = this.getHMCIpAddr();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "FedSwitchRepair.start exception caught getting hmc ip address; using 127.0.0.1");
                    hmcIPAddress = "127.0.0.1";
                }
                ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
                ExternalDataAccess eda = null;
                try {
                    ExternalDataAccessFactory edaf = (ExternalDataAccessFactory)ms.getFactory("ExternalDataAccessFactory");
                    if (edaf == null) {
                        Trace.trace(TRACE_MASKT, "<-! FedSwitchRepair.start ExternalDataAccessFactory not set in userData");
                        throw new ServiceActionException("ExternalDataAccessFactory not set in userData");
                    }
                    eda = edaf.create(null);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-! FedSwitchRepair.start undable to create ExternalDataAccess, exception=" + e);
                    Trace.trace(TRACE_MASKT, e);
                }
                displayMap.put("EXTERNAL_DATA_ACCESS", eda);
                displayMap.put("HMC_HOSTNAME", hmcIPAddress);
                eda.setToken((Serializable)((Object)this.makeInfoCenterURL(hmcIPAddress, clientLocale)));
                PBCommonPostInfoCenterRepairSupport returnPanelBean = new PBCommonPostInfoCenterRepairSupport();
                returnPanelBean.setDataMap(displayMap);
                returnPanelBean = (PBCommonPostInfoCenterRepairSupport)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", returnPanelBean.getTemplateName(), returnPanelBean, userData);
                if (returnPanelBean.isFirstRadioButtonSelected()) {
                    this.postInfocenterProcedures(userData);
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "!!! FedSwitchRepair.start exception caught and ignored: " + e);
                Trace.trace(TRACE_MASKF, e);
            }
        }
        finally {
            super.showStopped(userData);
        }
        Trace.trace(TRACE_MASKT, "<- FedSwitchRepair.start");
    }

    private void postInfocenterProcedures(Map userData) throws Exception {
        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
        PIProblem problem = (PIProblem)userData.get("SERVICEABLE_EVENT");
        if (problem != null) {
            String endOfCallComments = "";
            String additionalFrusExchanged = "";
            PBCommonPostInfoCenterIsolateQuery20 isolateQuery20PB = new PBCommonPostInfoCenterIsolateQuery20();
            if ((isolateQuery20PB = (PBCommonPostInfoCenterIsolateQuery20)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", isolateQuery20PB.getTemplateName(), isolateQuery20PB, userData)).isFirstRadioButtonSelected()) {
                List calledOutFrus = problem.getParts();
                Vector vRowData = new Vector();
                if (calledOutFrus != null) {
                    Iterator it = calledOutFrus.iterator();
                    while (it.hasNext()) {
                        PIFru pif = (PIFru)it.next();
                        if (pif.getFruClass() != 1) continue;
                        Vector<String> vRow = new Vector<String>();
                        String locCode = "";
                        ArrayList locations = pif.getLocationList();
                        if (locations == null || locations.size() == 0) continue;
                        Iterator locsIt = locations.iterator();
                        boolean first = true;
                        while (locsIt.hasNext()) {
                            locCode = locCode + (first ? (String)locsIt.next() : "," + (String)locsIt.next());
                            first = false;
                        }
                        vRow.add(locCode);
                        String desc = pif.getDescription();
                        if (desc == null) {
                            desc = "";
                        }
                        vRow.add(desc);
                        vRowData.add(vRow);
                    }
                }
                boolean onlyCalledOutFrusExchanged = true;
                if (vRowData.size() > 0) {
                    String selectedRadioButton;
                    TextTableAnd3ButtonGroupDataBean pb = new PBFedSwitchRepair30(new Vector(), vRowData);
                    int[] aiSelected = (pb = (TextTableAnd3ButtonGroupDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", pb.getTemplateName(), pb, userData)).getFruTableSelection();
                    if (aiSelected.length > 0) {
                        for (int i = 0; i < aiSelected.length; ++i) {
                            Vector row = pb.getFruTableVectorRowAt(aiSelected[i]);
                            String selectedFruLocation = row.elementAt(0).toString();
                            String selectedFruDesc = row.elementAt(1).toString();
                            Fru internalFru = new Fru(){};
                            HashMap<String, String> fruprops = new HashMap<String, String>();
                            fruprops.put("DESC", selectedFruDesc);
                            fruprops.put("LOCATION", selectedFruLocation);
                            internalFru.setProperties(fruprops);
                            Vector<1> exchangedFrus = (Vector<1>)userData.get("EXCHANGED_FRUS");
                            if (exchangedFrus == null) {
                                exchangedFrus = new Vector<1>();
                                userData.put("EXCHANGED_FRUS", exchangedFrus);
                            }
                            exchangedFrus.add(internalFru);
                        }
                    }
                    if ((selectedRadioButton = pb.getButtongroupSelection()[0]).equals("RadioButton2")) {
                        onlyCalledOutFrusExchanged = false;
                    }
                } else {
                    onlyCalledOutFrusExchanged = false;
                }
                if (!onlyCalledOutFrusExchanged) {
                    PBFedSwitchRepair40 addFrusBean = new PBFedSwitchRepair40();
                    String fruInfo = (addFrusBean = (PBFedSwitchRepair40)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", addFrusBean.getTemplateName(), addFrusBean, userData)).getEditBoxText();
                    if (fruInfo != null) {
                        additionalFrusExchanged = "Additional exchanged FRU information:\n" + fruInfo;
                    }
                }
            }
            PBCommonEnterRepairDescription descBean = new PBCommonEnterRepairDescription();
            endOfCallComments = (descBean = (PBCommonEnterRepairDescription)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", descBean.getTemplateName(), descBean, userData)).getEditBoxText();
            problem.addFixDescription(endOfCallComments == null ? additionalFrusExchanged : endOfCallComments + "\n" + additionalFrusExchanged);
            problem.addCeComments("", endOfCallComments == null ? additionalFrusExchanged : endOfCallComments + "\n" + additionalFrusExchanged);
            ProblemManager.getProblemManager().close(problem);
            PIEndOfCall.endOfCallProcessing(userData);
        }
    }

    protected String makeInfoCenterURL(String ipaddr, Locale locale) {
        Trace.trace(TRACE_MASKT, "-> FedSwitchRepair.makeURL (locale=" + locale + ")");
        String infoCenterFileName = this.procedureId.toLowerCase() + ".htm";
        String correctUrl = ":4411/eserver/HW/" + locale.getLanguage() + "_" + locale.getCountry() + "/info/iphau/";
        String enUsUrl = ":4411/eserver/HW/en_US/info/iphau/";
        if (correctUrl.length() != enUsUrl.length()) {
            Trace.trace(TRACE_MASKF, "FedSwitchRepair.makeURL unknown/unsupported locale[" + locale + "], using en_US");
            correctUrl = enUsUrl;
        }
        String retUrl = "http://" + ipaddr + correctUrl + infoCenterFileName;
        Trace.trace(TRACE_MASKT, "<- FedSwitchRepair.makeURL: " + retUrl);
        return retUrl;
    }

    protected String getHMCIpAddr() throws Exception {
        String ipaddr;
        block7: {
            Trace.trace(TRACE_MASKT, "-> FedSwitchRepair.getHMCIpAddr");
            ipaddr = null;
            String toms_hn = null;
            String name = null;
            String domain = null;
            try {
                ipaddr = InetAddress.getLocalHost().getHostAddress();
                if (ipaddr != null) {
                    Trace.trace(TRACE_MASKF, "-- HMC hostname returned from getHostAddress() call is <" + ipaddr + ">");
                    break block7;
                }
                Trace.trace(TRACE_MASKF, "-- HMC hostname returned is null, trying alternate hostname...");
                try {
                    name = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                    domain = NetworkSettings.getNetworkSettings().getNetworkInfo().getDomainName();
                    toms_hn = domain != null ? name + "." + domain : name;
                    Trace.trace(TRACE_MASKF, "-- HMC hostname returned from Network Settings call is <" + toms_hn + ">");
                    ipaddr = toms_hn;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "-- NetworkSettings exception is " + e + ", rethrowing...");
                    throw e;
                }
            }
            catch (UnknownHostException uhe) {
                Trace.trace(TRACE_MASKF, "-- caught unknown host exception, try alternate call...>");
                try {
                    name = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                    domain = NetworkSettings.getNetworkSettings().getNetworkInfo().getDomainName();
                    toms_hn = domain != null ? name + "." + domain : name;
                    Trace.trace(TRACE_MASKF, "-- HMC hostname returned from Network Settings call is <" + toms_hn + ">");
                    ipaddr = toms_hn;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "-- NetworkSettings exception is " + e);
                    throw e;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- FedSwitchRepair.getHMCIpAddr");
        return ipaddr;
    }
}

